/************************************************************************************
*  Copyright (c), 2013, HelTec Automatic Technology co.,LTD.
*            All rights reserved.
*
* Http:    www.heltec.cn
* Email:   cn.heltec@gmail.com
* WebShop: heltec.taobao.com
*
* File name: LQ12864.h
* Project  : OLED
* Processor: STC89C52
* Compiler : Keil C51 Compiler
* 
* Author : С
* Version: 1.00
* Date   : 2013.8.8
* Email  : hello14blog@gmail.com
* Modification: none
* 
* Description:128*64OLEDģļheltec.taobao.com۲Ʒ
*
* Others: none;
*
* Function List:
*
* 1. void LCD_DLY_ms(unsigned int ms) -- OLEDõʱ,вҪô˳
* 2. void LCD_WrDat(unsigned char dat) -- OLEDд
* 3. void LCD_WrCmd(unsigned char cmd) -- OLEDд
* 4. void LCD_Set_Pos(unsigned char x, unsigned char y) -- ʾ
* 5. void LCD_Fill(unsigned char bmp_dat) -- ȫʾ(ʾBMPͼƬʱŻõ˹)
* 6. void LCD_CLS(void) -- λ/
* 7. void LCD_Init(void) -- OLEDʼ򣬴˺ӦڲĻ֮ǰȵ
* 8. void LCD_P6x8Str(unsigned char x, y,unsigned char ch[]) -- 6x8ʾASCIIСУ̫
* 9. void LCD_P8x16Str(unsigned char x, y,unsigned char ch[]) -- 8x16ʾASCII룬ǳ
* 10.void LCD_P16x16Ch(unsigned char x, y, N) -- 16x16ʾֵСУø塢Ӵ֡б»ߵ
* 11.void Draw_BMP(unsigned char x0, y0,x1, y1,unsigned char BMP[]) -- 128x64صBMPλͼȡֱȻƵcodetabУ˺ü
*
* History: none;
*
*************************************************************************************/

#include "REG52.h"

/********************
*
* IOģSPI
* P1.0ڽģϵD/C
* P1.1ڽģϵCS
* P1.2ڽģϵMISO
* P1.3ڽģϵCLK
*
*********************/

sbit LCD_CLK =P1^3; //ʱ D0SCLK
sbit LCD_MOSI=P1^2; //D1MOSI 
sbit LCD_CS  =P1^1; //λ 
sbit LCD_DC  =P1^0; ///

#define XLevelL			0x00
#define XLevelH			0x10
#define XLevel	    ((XLevelH&0x0F)*16+XLevelL)
#define Max_Column	128
#define Max_Row			64
#define	Brightness	0xCF 
#define X_WIDTH 		128
#define Y_WIDTH 		64
/************************ʱ************************************/
void delay(unsigned int z)
{
	unsigned int x,y;
	for(x=z;x>0;x--)
		for(y=110;y>0;y--);
}
/*********************LCDд************************************/ 
void LCD_WrDat(unsigned char dat)	 
{
	unsigned char i;
	LCD_DC=1;  
	for(i=0;i<8;i++) //һλ 
	{
		if((dat << i) & 0x80)
		{
			LCD_MOSI  = 1;
		}
		else  LCD_MOSI  = 0;
		LCD_CLK = 0;
		LCD_CLK = 1;
	}
}
/*********************LCDд************************************/										
void LCD_WrCmd(unsigned char cmd)
{
	unsigned char i;
	LCD_DC=0;
	for(i=0;i<8;i++) //һλ 
	{
		if((cmd << i) & 0x80)
		{
			LCD_MOSI  = 1;
		}
		else 
		{
			LCD_MOSI  = 0;
		}
		LCD_CLK = 0;
		LCD_CLK = 1;
	}
}
/*********************LCD ************************************/
void LCD_Set_Pos(unsigned char x, unsigned char y) 
{ 
	LCD_WrCmd(0xb0+y);
	LCD_WrCmd(((x&0xf0)>>4)|0x10);
	LCD_WrCmd((x&0x0f)|0x01); 
} 
/*********************LCDȫ************************************/
void LCD_Fill(unsigned char bmp_dat) 
{
	unsigned char y,x;
	for(y=0;y<8;y++)
	{
		LCD_WrCmd(0xb0+y);
		LCD_WrCmd(0x01);
		LCD_WrCmd(0x10);
		for(x=0;x<X_WIDTH;x++)
		LCD_WrDat(bmp_dat);
	}
}
/*********************LCDλ************************************/
void LCD_CLS(void)
{
	unsigned char y,x;	
	for(y=0;y<8;y++)
	{
		LCD_WrCmd(0xb0+y);
		LCD_WrCmd(0x01);
		LCD_WrCmd(0x10); 
		for(x=0;x<X_WIDTH;x++)
		LCD_WrDat(0);
	}
}
/*********************LCDʼ************************************/
void LCD_Init(void)     
{
	delay(500);//ʱҪ,һ50ms,ԳһЩ
	LCD_CS=0;
	LCD_WrCmd(0xae);//--turn off oled panel
	LCD_WrCmd(0x00);//---set low column address
	LCD_WrCmd(0x10);//---set high column address
	LCD_WrCmd(0x40);//--set start line address  Set Mapping RAM Display Start Line (0x00~0x3F)
	LCD_WrCmd(0x81);//--set contrast control register
	LCD_WrCmd(0xcf); // Set SEG Output Current Brightness
	LCD_WrCmd(0xa1);//--Set SEG/Column Mapping     0xa0ҷ 0xa1
	LCD_WrCmd(0xc8);//Set COM/Row Scan Direction   0xc0· 0xc8
	LCD_WrCmd(0xa6);//--set normal display
	LCD_WrCmd(0xa8);//--set multiplex ratio(1 to 64)
	LCD_WrCmd(0x3f);//--1/64 duty
	LCD_WrCmd(0xd3);//-set display offset	Shift Mapping RAM Counter (0x00~0x3F)
	LCD_WrCmd(0x00);//-not offset
	LCD_WrCmd(0xd5);//--set display clock divide ratio/oscillator frequency
	LCD_WrCmd(0x80);//--set divide ratio, Set Clock as 100 Frames/Sec
	LCD_WrCmd(0xd9);//--set pre-charge period
	LCD_WrCmd(0xf1);//Set Pre-Charge as 15 Clocks & Discharge as 1 Clock
	LCD_WrCmd(0xda);//--set com pins hardware configuration
	LCD_WrCmd(0x12);
	LCD_WrCmd(0xdb);//--set vcomh
	LCD_WrCmd(0x40);//Set VCOM Deselect Level
	LCD_WrCmd(0x20);//-Set Page Addressing Mode (0x00/0x01/0x02)
	LCD_WrCmd(0x02);//
	LCD_WrCmd(0x8d);//--set Charge Pump enable/disable
	LCD_WrCmd(0x14);//--set(0x10) disable
	LCD_WrCmd(0xa4);// Disable Entire Display On (0xa4/0xa5)
	LCD_WrCmd(0xa6);// Disable Inverse Display On (0xa6/a7) 
	LCD_WrCmd(0xaf);//--turn on oled panel
	LCD_Fill(0x00);  //ʼ
	LCD_Set_Pos(0,0); 	
} 
/***************ʾ6*8һ׼ASCIIַ	ʾ꣨x,yyΪҳΧ07****************/
void LCD_P6x8Str(unsigned char x, y,unsigned char ch[])
{
	unsigned char c=0,i=0,j=0;
	while (ch[j]!='\0')
	{
		c =ch[j]-32;
		if(x>126){x=0;y++;}
		LCD_Set_Pos(x,y);
		for(i=0;i<6;i++)
		LCD_WrDat(F6x8[c][i]);
		x+=6;
		j++;
	}
}
/*******************ʾ8*16һ׼ASCIIַ	 ʾ꣨x,yyΪҳΧ07****************/
void LCD_P8x16Str(unsigned char x, y,unsigned char ch[])
{
	unsigned char c=0,i=0,j=0;
	while (ch[j]!='\0')
	{
		c =ch[j]-32;
		if(x>120){x=0;y++;}
		LCD_Set_Pos(x,y);
		for(i=0;i<8;i++)
		LCD_WrDat(F8X16[c*16+i]);
		LCD_Set_Pos(x,y+1);
		for(i=0;i<8;i++)
		LCD_WrDat(F8X16[c*16+i+8]);
		x+=8;
		j++;
	}
}
/*****************ʾ16*16  ʾ꣨x,yyΪҳΧ07****************************/
void LCD_P16x16Ch(unsigned char x, y, N)
{
	unsigned char wm=0;
	unsigned int adder=32*N;
	LCD_Set_Pos(x , y);
	for(wm = 0;wm < 16;wm++)
	{
		LCD_WrDat(F16x16[adder]);
		adder += 1;
	}
	LCD_Set_Pos(x,y + 1);
	for(wm = 0;wm < 16;wm++)
	{
		LCD_WrDat(F16x16[adder]);
		adder += 1;
	} 	  	
}
/***********ʾʾBMPͼƬ12864ʼ(x,y),xķΧ0127yΪҳķΧ07*****************/
void Draw_BMP(unsigned char x0, y0,x1, y1,unsigned char BMP[])
{ 	
 unsigned int j=0;
 unsigned char x,y;
  
  if(y1%8==0) y=y1/8;      
  else y=y1/8+1;
	for(y=y0;y<y1;y++)
	{
		LCD_Set_Pos(x0,y);
    for(x=x0;x<x1;x++)
	    {      
	    	LCD_WrDat(BMP[j++]);	    	
	    }
	}
} 
